type Person = {
    id: string,
    name: string,
    city: string,
    getContact(field: string): string
};

type Employee = {
    id: string,
    company: string,
    dept: string
    getContact(field: number): number
};

type EmployedPerson = Person & Employee;

let person: EmployedPerson = {
    id: "bnowak", name: "Bartek Nowak", city: "Londyn",
    company: "Acme Co", dept: "handlowiec",
    getContact(field: string | number): any {
        return typeof field === "string" ? "Alicja" : 6512346543;
    }
};

let typeTest = person.getContact;
let stringParamTypeTest = person.getContact("Alicja");
let numberParamTypeTest = person.getContact(123);

console.log(`Typ Contact: ${person.getContact("Alicja")}`);
console.log(`Typ Contact: ${person.getContact(12)}`);